 ; Ŀ
 ;   Pac - suck two lines of text, put into one.                           
 ;   Also contains:                                                        
 ;    Cap - suck one line of text, split, put into two.                    
 ;    Jef - suck text out of a device tag, modify, put in wire tags.       
 ;   Copyright 1996, 2001, 2002, 2005, 2008 by Rocket Software Ltd.        
 ;   There are creatures which live in solid, liquid, and gas, but none    
 ;   which live in plasma - no fluorescent tube guppies.                   
 ; 

 ; Ŀ
 ;   Subroutine Loose - takes a string as an argument, prompts for an      
 ;   entity nentsel, puts the string into the entity.                      
 ;   Returns an ename if something was selected, otherwise nil.            
 ; 
 (DEFUN LOOSE (str / nent enam entt typ outer nn)
  (if (setq enam (car (setq nent (nentsel (strcat "<" str ">: ")))))
      (setq typ (cdr (assoc 0 (setq entt (entget enam))))))
  (if (and enam (or (= "TEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ)))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (entmod (subst (cons 1 str) (assoc 1 entt) entt))
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer)))
      (progn
           (if enam (write-line "That wasn't anything like text."))
           (setq enam ())))
 (if enam enam ()))
 ; Ŀ
 ;   Loose end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string at a given character, make    
 ;   into a list of substrings.                                            
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (and (/= linn "")
                     (= (substr linn (setq len (strlen linn))) " "))
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= name1 "")
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Splist - split a string at any character in a list.        
 ;   Does not currently remove excess spaces unless they are passed in     
 ;   the list of separator characters.                                     
 ;   Arguments: Astr: the string to process.                               
 ;              Chlis: the list of separator characters.                   
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN SPLIST (astr chlis / pos sub chra nulis)
  (setq pos 1)
  (setq sub "")
  (while (and (setq chra (substr astr pos 1))
              (/= chra ""))
         (if (member chra chlis)
             (if (/= sub "")
                 (progn
                      (setq nulis (append nulis (list sub)))
                      (setq sub "")))
             (setq sub (strcat sub chra)))
         (setq pos (1+ pos)))
  (if (/= sub "") (setq nulis (append nulis (list sub))))
 nulis)
 ; Ŀ
 ;   Splist end.                                                           
 ; 

 ; Ŀ
 ;   Tatere - extract the string from an entity.                           
 ;   Arguments: Promo, the prompt string.                                  
 ;   Calls nothing.                                                        
 ;   Returns a string or nil.                                              
 ; 
 (DEFUN TATERE (promo / nn cc)
  (if (and (setq nn (nentsel (strcat "\n" promo)))
           (setq cc (assoc 1 (entget (car nn)))))
      (progn
           (setq cc (cdr cc))
           (princ (strcat cc "\n"))))
 cc)
 ; Ŀ
 ;   Tatere - extract the string from an entity.                           
 ; 

 ; Ŀ
 ;   Cap.                                                                  
 ; 
 (DEFUN C:CAP (/ *error* snapp str strlis str1 str2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make the new local error handler, turn off snap.                      
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
  (princ))
 ; Ŀ
 ;   Get a string, preferably of the form a-b.                             
 ; 
  (setq str (tatere "Tag: "))
 ; Ŀ
 ;   Split it into substrings.                                             
 ; 
  (setq strlis (splist str (list " " "-")))
  (setq num 0)
  (while (setq str (nth num strlis))
         (setq num (1+ num))
         (loose str))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Jef.                                                                  
 ; 
 (DEFUN C:JEF ( / *error* snapp str num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a new local error handler.                                       
 ; 
 (DEFUN *error* (shk /)
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Get a string.                                                         
 ; 
  (setq str (tatere "Select A Device Tag: "))
 ; Ŀ
 ;   Make and install new strings.                                         
 ; 
  (setq num 1)
  (while (loose (strcat str "-" (itoa num)))
         (setq num (1+ num)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))

 ; Ŀ
 ;   Pac.                                                                  
 ; 
 (DEFUN C:PAC ( / *error* snapp str1 str2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make the new local error handler, turn off snap.                      
 ; 
 (DEFUN *error* (shk /) (setvar "snapmode" snapp) (princ))
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Get two strings.                                                      
 ; 
  (if (and (setq str1 (tatere "First string: "))
           (setq str2 (tatere "Second string: ")))
 ; Ŀ
 ;   Mash them together, put the result into the new entity.               
 ; 
      (loose (strcat str1 "-" str2)))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "snapmode" snapp)
  (command "undo" "end")
 (princ))

(prompt "C:Pac/C:Cap/C:Jef")
(princ)
